/******************************************************************************/
class ToggleDoor : BaseEvent
{
public:
            ToggleDoor();
   virtual ~ToggleDoor();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   UID m_DoorUID;
   SlidingDoor* m_Door;
   bool m_Open;
};
/******************************************************************************/
ToggleDoor::ToggleDoor() : BaseEvent(), m_Open(false), m_Door(null)                          
{
   
}
ToggleDoor::~ToggleDoor()
{
   
}
/******************************************************************************/
void ToggleDoor::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("DoorUID")) m_DoorUID = p.asID();
   if(Param *p = obj.findParam("Open"))    m_Open    = p.asBool();  
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void ToggleDoor::AfterCreate()
{
   // Find the correct Door to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(slidingDoors)
      if(slidingDoors[i].id() == m_DoorUID)
            m_Door = &slidingDoors[i];
            
   DEBUG_ASSERT(m_Door, "SlidingDoor not found in scene"); 
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void ToggleDoor::CallTriggeredAction()
{
   // (un)lock the door
   m_Door.SetLocked(!m_Open);
}

// This method is called when the duration of the event has been reached
void ToggleDoor::StopTriggeredAction()
{
   // If m_Duration is not -1, the door can (un)lock again after some time
   m_Door.SetLocked(m_Open);
}
/******************************************************************************/